
(* 2x2 flyways w/ 1 xbots sample trajectory set as trajectory 1 (time interval = 10 ms) - trajectory, pause, resume, stop, deactivate, reboot, activate, levitate, arc center *)
FUNCTION_BLOCK Example05_pmccontrol
	(*move xbot 1 to 240,240*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := Execute,cmdLB := 1,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.24,PosY := 0.24,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*xbot 1 does trajectory 1*)
	xbotID_array12[0] := 1; trajID_array12[0] := 1;
	PMC_ActivateTrajectory1(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,cmdLB := 2,nXbots := 1,XbotID := xbotID_array12,TrajID := trajID_array12);

	Delay1(Execute := PMC_ActivateTrajectory1.Ack,Cycles := 5000);

	(*pause xbot 1*)
	PMC_PauseXbots1(PM_Controller := PM_Controller,Execute := Delay1.Done,XbotID := 1);

	Delay2(Execute := PMC_PauseXbots1.Done,Cycles := 5000);

	(*resume xbot 1*)
	PMC_ResumeXbots1(PM_Controller := PM_Controller,Execute := Delay2.Done,XbotID := 1);

	Delay3(Execute := PMC_ResumeXbots1.Done,Cycles := 4500);

	(*stop xbot 1*)
	PMC_StopXbots1(PM_Controller := PM_Controller,Execute := Delay3.Done,XbotID := 1);

	(*360 around 240,240*)
	PMC_ArcMotionCenter1(PM_Controller := PM_Controller,Execute := PMC_StopXbots1.Done,cmdLB := 6,XbotID := 1,Mode := 0,Dir := 0,EndVel := 0,MaxVel := 1,MaxAcc := 10,CenterX := 0.24,CenterY := 0.24,Angle := 6.283);

	(*deactivate PMC*)
	PMC_DeactivateXbots1(PM_Controller := PM_Controller,Execute := PMC_ArcMotionCenter1.Done);

	Delay4(Execute := PMC_DeactivateXbots1.Done,Cycles := 2000);

	(*reboot PMC*)
	PMC_Reboot1(PM_Controller := PM_Controller,Execute := Delay4.Done);

	Delay5(Execute := PMC_Reboot1.Done,Cycles := 2000);

	(*activate PMC*)
	PMC_ActivateXbots1(PM_Controller := PM_Controller,Execute := Delay5.Done);

	Delay6(Execute := PMC_ActivateXbots1.Done,Cycles := 2000);

	(*Land xbot 1*)
	PMC_LevitationCtrl1(PM_Controller := PM_Controller,Execute := Delay6.Done,XbotID := 1,Level := 0,Speed := 0,LandedZForce := 0);

	Delay7(Execute := PMC_LevitationCtrl1.Done,Cycles := 2000);

	(*Levitate xbot 1*)
	PMC_LevitationCtrl2(PM_Controller := PM_Controller,Execute := Delay7.Done,XbotID := 1,Level := 1,Speed := 0,LandedZForce := 0);

	Done := PMC_LevitationCtrl2.Done;
END_FUNCTION_BLOCK
